;-------------------------------------------------------------------------

; G8BPQ to FOSSIL driver by Denis Nechitailov, UU9JDR      1996,97

; tasm.exe /dcom=<port> /dstre=<stream> /dapplm=<applmask> fe2.asm
; tlink.exe /t fe2.obj

; <port>     -  , 稭  
; <stream>   -   ⮪  switch
; <applmask> - ᪠ application, ᮮ⢥⢥  bpqcfg.txt 
;               யᠭ  application

;-------------------------------------------------------------------------
ideal
model tiny
;-------------------------------------------------------------------------

VERS	=	2	; H ᨨ  ࠩ

ifdef com
 COMPORT	= com	; H COM- (0=COM1,1=COM2 etc)
else
 COMPORT	= 3	; H COM- (0=COM1,1=COM2 etc)
endif

ifdef stre
 STREAM		= stre	; ⮪ 裡  BPQ
else
 STREAM		= 11	; ⮪ 裡  BPQ
endif

ifdef applm
 APPLMASK	= applm		; ᪠ application
else
 APPLMASK	= 00001000b	; ᪠ application
endif

MAXFUNC		= 1Bh	; H ᫥ 㭪樨,  ন ࠩ

MAJVER		= 5	;  FOSSIL-ࠩ
MINVER		= 12h

OUT_LEN		= 254	;    ।  BPQ
MAX_BUF		= 254	; ᨬ ࠧ   ।  BPQ

REST_BUFS	= 20	; 쭮 ⠢塞 ⢮ ஢  switch

BPQINT		= 7Fh	; 뢠 -० BPQ
BPQMAJ		= 4	;  BPQ
BPQMIN		= 6

APPLFLAG	= 6	;  application

;-------------------------------------------------------------------------

;    筮 ᫠

macro decnum zzz
	if zzz ge 100
		db	'0'+zzz/100
	endif
	if zzz ge 10
		db	'0'+(zzz mod 100)/10
	endif
		db	'0'+(zzz mod 10)
endm

;-------------------------------------------------------------------------

codeseg
startupcode

	jmp	install

;-------------------------------------------------------------------------

out_buf		db	OUT_LEN dup (?)	; 室 
out_count	dw	0	; ⮥ 

info	= $               ; define begin of structure
strsiz  dw      info_size       ; size of the structure in bytes
maj_ver db      MAJVER          ; FOSSIL spec driver conforms to
min_ver db      MINVER          ; rev level of this specific driver
ident   dd      ?               ; "FAR" pointer to ASCII ID string
ibufr   dw      1		; size of the input buffer (bytes)
ifree   dw      1		; number of bytes left in buffer
obufr   dw      1		; size of the output buffer (bytes)
ofree   dw      1		; number of bytes left in the buffer
swidth  db      50h             ; width of screen on this adapter
sheight db      19h             ; height of screen    "     "
baud    db      0               ; ACTUAL baud rate, computer to modem
info_size 	= $-info

id_string	db	'BPQ driver by DN v#'
		decnum (VERS)
		db	', port='
		decnum (COMPORT)
		db	', stream='
		decnum (STREAM)
		db	', applmask='
		decnum (APPLMASK)
		db	0

byte_buf	db	?	;    transmit no wait
chars	dw	0
pos	dw	0
buf	db	340	dup (?),?

;-------------------------------------------------------------------------

; ࠡ稪 INT 14h

int14_handler:
	jmp	short int14_cmpnum
	
	db	0,0,0	;  ᬥ饭 6 ⭮⥫쭮 砫 - ᨣ

	dw	1954h
	db	MAXFUNC

int14_cmpnum:
	cmp	dx,COMPORT	; ࡠ뢠  ⮫쪮  ᢮ 
	jne	int14_master

	cmp	ah,0	;  ᨬ   㭪樨 믮塞 ࠧ
	je	process_0

	cmp	ah,1
	je	process_1

	cmp	ah,2
	je	process_2

	cmp	ah,3
	je	process_3

	cmp	ah,4
	je	process_4

	cmp	ah,5
	jne	n5
	jmp	process_5
n5:
	cmp	ah,6
	jne	n6
	jmp	process_6
n6:
	cmp	ah,0Bh
	jne	n0B
	jmp	process_0B

n0B:
	cmp	ah,18h
	jne	n18
	jmp	process_18

n18:
	cmp	ah,19h
	jne	n19
	jmp	process_19

n19:
	cmp	ah,1Bh
	jne	int14_exit
	jmp	process_1B

int14_exit:
	iret

int14_master:
	db	0EAh,0,0,0,0	; jmp far seg:offs


;-------------------------------------------------------------------------

; ࠡ⪠ 㭪樨 0 - ⠭ ᪮ ࠡ

process_0:

	call	get_status	; 砥  ࠩ

	jmp	int14_exit

;-------------------------------------------------------------------------

; ࠡ⪠ 㭪樨 1 - । 

process_1:

	call	get_status	; 砥  ࠩ

	jmp	int14_exit

;-------------------------------------------------------------------------

; ࠡ⪠ 㭪樨 2 - ਥ 

process_2:

	push	es
	push	di
	push	cx

	mov	di,[pos]
	cmp	di,[chars]
	jne	p2_frombuf

p2_again:
	mov	cx,340
	mov	di,offset buf
	push	cs
	pop	es

	mov	ah,18h
	int	14h

	cmp	ax,0
	je	p2_again

	mov	[chars],ax

p2_frombuf:
	mov	di,[pos]
	mov	al,[cs:buf+di]
	inc	[pos]

	mov	ah,0

	pop	cx
	pop	di
	pop	es

	jmp	int14_exit

;-------------------------------------------------------------------------

; ࠡ⪠ 㭪樨 3 - 

process_3:

	call	get_status	; 砥  ࠩ

	jmp	int14_exit

;-------------------------------------------------------------------------

; ࠡ⪠ 㭪樨 4 - 樠 ࠩ

process_4:
	
;	call	bpq_disc	; ᮥ塞  BPQ

	mov	ah,1		; ⠭ ᪨  䫠 application
	mov	dl,APPLMASK
	mov	cl,APPLFLAG
	call	call_bpq

	mov	ax,1954h	; 頥 
	mov	bl,MAXFUNC
	mov	bh,MAJVER

	jmp	int14_exit

;-------------------------------------------------------------------------

; ࠡ⪠ 㭪樨 5 - 樠 ࠩ

process_5:

	call	bpq_disc	; ᮥ塞  BPQ

	mov	ah,1		; ⠭ ᪨  䫠 application
	mov	dl,0		; APPLMASK=0,  ᮥ 
	mov	cl,APPLFLAG
;	call	call_bpq	; H 㢥७,   㦭 

	jmp	int14_exit

;-------------------------------------------------------------------------

; ࠡ⪠ 㭪樨 6 - ࠡ  DTR

process_6:

	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es

	cmp	al,1	; ⠢ DTR?
	jne	p6_disc

	mov	ah,6	; 塞  BPQ
	mov	cx,1	;  ᮥ
	call	call_bpq
	
	jmp	p6_exit

p6_disc:
	cmp	al,0	;  DTR?
	jne	p6_exit

	call	bpq_disc	; ᮥ塞  BPQ

p6_exit:
	pop	es
	pop	ds
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax

	jmp	int14_exit

;-------------------------------------------------------------------------

; ࠡ⪠ 㭪樨 0Bh - । ᨬ

process_0B:

	call	out_byte	; 襬  
	mov	ax,1		;  ਭ

	jmp	int14_exit

;-------------------------------------------------------------------------

; ࠡ⪠ 㭪樨 18h - ⥭ 

process_18:
	
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es

	mov	ah,3	;  
	call	call_bpq

	mov	ax,cx	; ᫮ ⠭ 

	pop	es
	pop	ds
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx

	jmp	int14_exit

;-------------------------------------------------------------------------

; ࠡ⪠ 㭪樨 19h -  

process_19:

	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es

	push	cx
	push	di
	push	es

	mov	ah,7	; ᨬ ⨪  ࠬ
	call	call_bpq

	pop	es
	pop	di
	pop	cx

	mov	ax,0
	cmp	dx,REST_BUFS	; ᫨ ஢ ⠫  -  塞
	jb	p19_exit

	cmp	cx,MAX_BUF
	jbe	p19_nodec

	mov	cx,MAX_BUF
;	call sound

p19_nodec:

	push	cx

;p19_next:
;	mov	al,es:[di]	; ६ । 
;	call	out_byte	; ।   BPQ १ 
;	inc	di
;	loop	p19_next	; 室  ᫥饬
;
;	mov	cx,cs:out_count	; ᫮ ⠢   ᨬ
;	cmp	cx,0	; ᫨ 祣  ⠫,   ।
;	je	p19_noflush
;
;	mov	ah,2	; । ⮪   BPQ
;	push	cs
;	pop	es
;	lea	si,out_buf
;	call	call_bpq
;
;	call	sound
;
;p19_noflush:
;
;
	mov	si,di

	mov	ah,2
	call	call_bpq

	pop	cx
	mov	ax,cx	; ᫮ । 

p19_exit:
	pop	es
	pop	ds
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx

	jmp	int14_exit

;-------------------------------------------------------------------------

; ࠡ⪠ 㭪樨 1Bh - ଠ  ࠩ

process_1B:
	
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es

	mov	ax,0
	cmp	cx,info_size
	jb	p1B_exit

	mov	ax,cs	; 뢠  ப ଠ樨
	mov	ds,ax
	mov	[word ptr ident+2],ax
	mov	ax, offset id_string
	mov	[word ptr ident],ax
	
	mov	si,offset info
	mov	cx,info_size

	rep	movsb	; 㥬 ப

	mov	ax,info_size	; ⢨⥫쭮 ᪮஢

p1B_exit:
	
	pop	es
	pop	ds
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx

	jmp	int14_exit

;-------------------------------------------------------------------------

; ᮥ  BPQ

bpq_disc:

	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es

	mov	ah,6	; ᮥ塞  BPQ
	mov	cx,2	;  ᮥ
	call	call_bpq

	mov	ah,1	; ⠭    䫠 application
	mov	cl,APPLFLAG
	mov	dl,APPLMASK
	call	call_bpq

	pop	es
	pop	ds
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax

	ret

;-------------------------------------------------------------------------

; ।   al  BPQ

out_byte:

	push	cx
	push	si

	mov	si,[cs:out_count]	; 襬 ।   
	mov	[cs:out_buf+si],al

	mov	cx,si	; 騩 
	inc	cx
	mov	[cs:out_count],cx

	cmp	al,13	; ᫨ 襫 '' - । 
	je	ob_write

	cmp	cx,OUT_LEN	; ᫨   - ।
	je	ob_write

	jmp	ob_exit

ob_write:
	push	es

	push	cs	; ⮢ 㪠⥫ ES:SI  ।
	pop	es
	mov	si,offset out_buf

	push	bx
	push	dx
	push	di
	push	bp
	push	ds

	mov	ah,2	; ।   BPQ
	call	call_bpq

	pop	ds
	pop	bp
	pop	di
	pop	dx
	pop	bx

	pop	es

	mov	[cs:out_count],0	;  ᭮ 

ob_exit:

	pop	si
	pop	cx

	ret

;-------------------------------------------------------------------------

; 맮 BPQ switch

call_bpq:

	mov	al,STREAM	; H ⮪
	int	BPQINT	; ⢥ 맮 BPQ

	ret

;-------------------------------------------------------------------------

; 祭  ࠩ  ah:al

get_status:

	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es

	mov	ah,7	;  ஢
	call	call_bpq

	mov	ax,0000000000001000b	; H砫쭮 祭 ॣ 

	cmp	bx,0	;    室  ?
	je	gs_noin

	or	ah,1	; , 

gs_noin:
;	cmp	dx,20	;     室 ?
	cmp	dx,0	;     室 ?
;	jb	gs_noout
	je	gs_noout

	or	ah,100000b	; , 

gs_noout:
	cmp	cx,0	;   室 ?
	jne	gs_nofree

	or	ah,1000000b	; , 

gs_nofree:

	push	ax

	mov	ah,4	; 砥  BPQ
	call	call_bpq

	pop	ax

	cmp	cx,1	;   ⮪  BPQ?
	jne	gs_exit

	or	al,10000000b	; , ᮥ - DCD 

gs_exit:

	push	ax

	mov	ah,5	; ⢥ত 
	call	call_bpq

	pop	ax

	pop	es
	pop	ds
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx

	ret

;-------------------------------------------------------------------------

sound:
	push	ax
	in	al,61h
	xor	al,2
	out	61h,al
	pop	ax
	ret

;-------------------------------------------------------------------------

; ⠭ ࠡ稪 뢠

install:

	mov	dx, offset intro	; ⠥ ਢ⢨
	mov	ah,9
	int	21h	

	mov	dx,COMPORT	; ஢ઠ   ⠭
	mov	ah,4
	int	14h

	cmp	ax,1954h
	jne	nodupe

	mov	dx, offset already	; 頥  ୮ ⠭
	mov	ah,9
	int	21h

nodupe:
	push	ds
	mov	ah,0	; H室  ࠡ稪
	mov	al,BPQINT
	add	ax,ax
	add	ax,ax
	mov	si,ax

	xor	ax,ax
	mov	ds,ax
	
	lds	si,[ds:si]
	sub	si,7	;   7  ࠭

	mov	di,offset g8bpq
	mov	cx,5
	rep	cmpsb	; ࠢ   ⠫

	je	switch_present	;  - switch 

	pop	ds

	mov	dx, offset nobpq	; ⠥ ப,  switch 
	mov	ah,9
	int	21h

	jmp	install_exit

switch_present:

	cmp	[byte ptr ds:si],BPQMAJ	; ஢塞  ᮮ⢥⢨ ᨨ
	jne	badver
	
	cmp	[byte ptr ds:si+1],BPQMIN
	je	verok

badver:
	pop	ds

	mov	dx,offset badbpq	; ⠥ ᮮ饭  宩 ᨨ
	mov	ah,9
	int	21h

	jmp	install_exit

verok:
	pop	ds

	mov	ax,3514h	;   ண ࠡ稪
	int	21h
	mov	[word ptr int14_master+1],bx
	mov	[word ptr int14_master+3],es

	mov	ah,25h		; ⠭  ࠡ稪
	mov	dx,offset int14_handler
	int	21h

	mov	ah,1		; ⠭ ᪨  䫠 application
	mov	dl,0
	mov	cl,APPLFLAG
	call	call_bpq

	mov	dx,offset drok	; ⠥ ப,  ࠩ 㦥 ᯥ譮
	mov	ah,9
	int	21h

	mov	dx,offset install	; ⠥ १⮬
	int	27h

install_exit:

	mov	dx,offset drbad	; ⠥ ப,  ࠩ  㦥
	mov	ah,9
	int	21h

	int	20h

;-------------------------------------------------------------------------

intro	db	'BPQ to FOSSIL driver by Denis Nechitailov, UU9JDR, version #'
	decnum (VERS)
	db	13,10
	db	'bpqint='
	decnum (BPQINT)
	db	', port='
	decnum (COMPORT)
	db	', stream='
	decnum (STREAM)
	db	', applmask='
	decnum (APPLMASK)
	db	13,10,'$'
already	db	'Warning: other FOSSIL is present!',13,10,'$'
drok	db	'Driver loaded OK',13,10,'$'
drbad	db	'Driver not loaded',13,10,'$'
g8bpq	db	'G8BPQ'
nobpq	db	'BPQ switch not loaded!',13,10,'$'
badbpq	db	'Bad version of G8BPQ switch!',13,10,'$'

;-------------------------------------------------------------------------

end
